.TH xbouncebits 1 "11 March 1992"
.SH NAME
xbouncebits - display moving bouncing bitmaps in the X11 root window
.SH SYNOPSIS
.B xbouncebits
.RB [ -display
.IR d ]
...
.RB [ -rtol ]
.RB [ -cycles
.IR n ]
.RB [ -id ]
.RB [ -jump|-glide|-gravity|-copies
.IR n ]
.I bitmap ...
.SH DESCRIPTION
.PP
.I Xbouncebits
displays moving bouncing bitmaps in the root window.
.SH OPTIONS
.PP
.I Xbouncebits
accepts all the usual X flags and resources, such as
.BR -display ,
.BR -fg ,
.BR -bg ,
.BR -rv ,
.BR -sync ,
and
.BR -xrm .
One unusual feature is that
.I xbouncebits
will accept more than one
.B -display
flag; the multiple displays are treated as one large virtual display,
all lined up next to each other from left to right.
Also, for any display specifications without an explicit screen number,
all screens will be used.
In particular, if you let the display default then
.I xbouncebits
will run on all screens of the default display.
.PP
.I Xbouncebits
also accepts the following flags:
.TP
.B -rtol
Treats multiple displays as if they are lined up right-to-left instead
of left-to-right.
X resource:
.BR rtol .
Default: off.
.TP
.B -cycles
Specifies how often the simulation runs, in cycles per second.
If you specify 0, it runs continuously (and you should probably
nice the
.I xbouncebits
process, or your interactive response will suffer).
X resource:
.BR cycles .
Default: 10.
.TP
.B -id
Forks a background process and prints the process-id to stdout.
Useful if you want to make a menu command to kill
.IR xbouncebits .
X resource:
.BR id .
Default: off.
.PP
The rest of the arguments are a list of bitmap files with interspersed
mode flags.
The mode flags apply to all bitmaps that follow them.
.TP
.B -jump
Bitmaps jump around the screen every few seconds.
This is the default mode.
.TP
.B -glide
Bitmaps glide slowly around the screen and bounce off each other.
.TP
.B -gravity
Like
.BR -glide ,
but the bitmaps are slowly attracted to the bottom of the screen.
.TP
.B -copies
Puts up
.I n
copies of the subsequent bitmaps.
.PP
You can mix modes freely; for example:
.nf
    xbouncebits cow.x cow.x cow.x cow.x cow.x -glide triangle.x
.fi
puts up three cows in jump mode and a triangle in glide mode.
The same setup using the
.B -copies
flag:
.nf
    xbouncebits -copies 5 cow.x -copies 1 -glide triangle.x
.fi
.PP
Note that while jump mode uses very little CPU time, glide and
gravity modes can use a substantial amount.
.SH DIAGNOSTICS
.TP
.B can't place bitmaps
This means that there wasn't enough room on the screen to fit all
the bitmaps you specified.
Try fewer or smaller bitmaps.
.SH "BUGS / DEFICIENCIES"
.PP
Doesn't handle masked images.
Not too hard to add, just an argument parsing question.
.PP
Doesn't handle color images.
This could be added trivially if there
was a standard X way (i.e. XPM) to read them in.
.SH "SEE ALSO"
.IR xsetroot (1)
.SH AUTHOR
Copyright (C) 1992 by Jef Poskanzer <jef@acme.com>.  All rights reserved.
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
