/* rects.h - some simple rectangle routines
**
** Copyright (C) 1992 by Jef Poskanzer <jef@acme.com>.  All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#ifndef _RECTS_H_
#define _RECTS_H_

/* Initialize the Rects package. */
extern void RectsInit(
#if NeedFunctionPrototypes
    void
#endif
);

/* Queue up a rectangle for repainting - better than sending an Expose event. */
extern void RectsInvalidate(
#if NeedFunctionPrototypes
    XRectangle*		/* rectP */,
    Bool		/* merge */
#endif
);

/* Return a rectangle to be repainted, if there are any. */
extern Bool RectsNextInvalid(
#if NeedFunctionPrototypes
    XRectangle*		/* rectP */
#endif
);

/* Make rect1 the union of rect1 and rect2. */
extern void RectsUnion(
#if NeedFunctionPrototypes
    XRectangle*		/* rect1P */,
    XRectangle*		/* rect2P */
#endif
);

/* Make rect1 the intersection of rect1 and rect2. */
extern void RectsIntersect(
#if NeedFunctionPrototypes
    XRectangle*		/* rect1P */,
    XRectangle*		/* rect2P */
#endif
);

/* Test whether rect1 and rect2 intersect. */
extern Bool RectsTouch(
#if NeedFunctionPrototypes
    XRectangle*		/* rect1P */,
    XRectangle*		/* rect2P */
#endif
);

/* Test whether rect1 is inside rect2. */
extern Bool RectsInside(
#if NeedFunctionPrototypes
    XRectangle*		/* rect1P */,
    XRectangle*		/* rect2P */
#endif
);

#endif /*_RECTS_H_*/
