/* users - show users, with those on a list highlighted
**
** version of 20apr92
**
** Copyright (C) 1990,1991,1992 by Jef Poskanzer <jef@acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <curses.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <utmp.h>
#include <sys/ioctl.h>

#include <malloc.h>

#ifndef UT_NAMESIZE
#define UT_NAMESIZE 8
#endif
#ifndef _PATH_UTMP
#define _PATH_UTMP "/etc/utmp"
#endif

#define TBUFSIZE 1024
#define DEFAULT_COLUMNS 80


static void
out_of_mem( void )
    {
    (void) fprintf( stderr, "out of memory\n" );
    exit( 1 );
    }


static int
putch( int ch )
    {
    putchar( ch );
    }


static void
add_user( char* user, char*** listP, int* nP, int* maxP )
    {
    if ( *nP >= *maxP )
	{
	if ( *maxP == 0 )
	    {
	    *maxP = 100;
	    *listP = (char**) malloc( (unsigned) ( *maxP * sizeof(char*) ) );
	    }
	else
	    {
	    *maxP *= 2;
	    *listP = (char**) realloc(
		(char*) *listP, (unsigned) ( *maxP * sizeof(char*) ) );
	    }
	if ( *listP == (char**) 0 )
	    out_of_mem();
	}
    (*listP)[*nP] = malloc( UT_NAMESIZE + 1 );
    if ( (*listP)[*nP] == (char*) 0 )
	out_of_mem();
    (void) strncpy( (*listP)[*nP], user, UT_NAMESIZE );
    (*listP)[*nP][UT_NAMESIZE] = '\0';
    ++*nP;
    }


static int
compare( a, b )
    char** a;
    char** b;
    {
    return strcmp( *a, *b );
    }


static int
in_list( char* str, char** list, int nlist )
    {
    static int i = 0;
    int c;

    /* This depends on *both* lists being sorted. */
    for ( ; i < nlist; ++i )
	{
	c = strcmp( list[i], str );
	if ( c == 0 )
	    return 1;
	if ( c > 0 )
	    break;
	}
    return 0;
    }


void
main( int argc, char** argv )
    {
    char* term;
    char* strptr;
    char* high_start;
    char* high_end;
    int dumb;
    char buf[TBUFSIZE];
    static char strbuf[TBUFSIZE];
    char* cp;
    char* cp2;
    struct utmp ut;
    FILE* fp;
    static char** hl;
    static char** users;
    int argn, uniq, i, j, cols, nhl, maxhl, nusers, maxusers;
    int wid;
#ifdef TIOCGWINSZ
  struct winsize ws;
#endif /*TIOCGWINSZ*/
    char* usage = "usage:  %s [-u] [-h highlist] ...\n";

    /* Check args. */
    argn = 1;
    uniq = 0;
    hl = (char**) 0;
    nhl = maxhl = 0;
    while ( argn < argc && argv[argn][0] == '-' )
	{
	if ( argv[argn][1] == 'u' )
	    uniq = 1;
	else if ( argv[argn][1] == 'h' && argn + 1 < argc )
	    {
	    /* Read a highlight list. */
	    ++argn;
	    fp = fopen( argv[argn], "r" );
	    if ( fp == (FILE*) 0 )
		{
		perror( argv[argn] );
		exit( 1 );
		}
	    while ( fgets( buf, sizeof(buf), fp ) != (char*) 0 )
		{
		/* Remove newline if any. */
		if ( buf[strlen(buf)-1] == '\n' )
		    buf[strlen(buf)-1] = '\0';
		/* Parse line into words and save. */
		cp = buf;
		for (;;)
		    {
		    for ( ; *cp == ' '; ++cp )
			;
		    if ( *cp == '\0' )
			break;
		    for ( cp2 = cp + 1; *cp2 != ' ' && *cp2 != '\0'; ++cp2 )
			;
		    if ( *cp2 == '\0' )
			{
			add_user( cp, &hl, &nhl, &maxhl );
			break;
			}
		    else
			{
			*cp2 = '\0';
			add_user( cp, &hl, &nhl, &maxhl );
			cp = cp2 + 1;
			}
		    }
		}
	    (void) fclose( fp );
	    }
	else
	    {
	    (void) fprintf( stderr, usage, argv[0] );
	    exit( 1 );
	    }
	++argn;
	}

    if ( argn != argc )
	{
	(void) fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    /* Initialize terminal stuff. */
    dumb = 1;
    cols = DEFAULT_COLUMNS;
    if ( isatty( fileno( stdout ) ) )
	{
	/* Termcap. */
	term = getenv( "TERM" );
	if ( term != (char*) 0 && tgetent( buf, term ) == 1 )
	    {
	    strptr = strbuf;
	    high_start = tgetstr( "md", &strptr );
	    high_end = tgetstr( "me", &strptr );
	    if ( high_start != (char*) 0 && high_end != (char*) 0 )
		dumb = 0;
	    else
		{
		strptr = strbuf;
		high_start = tgetstr( "so", &strptr );
		high_end = tgetstr( "se", &strptr );
		if ( high_start != (char*) 0 && high_end != (char*) 0 )
		    dumb = 0;
		}
	    /* Get termcap terminal width. */
	    if ( tgetstr( "co", &strptr ) != (char*) 0 )
		cols = tgetnum("co");
	    }
#ifdef TIOCGWINSZ
	/* Get stty terminal width. */
	if ( ioctl( 0, TIOCGWINSZ, &ws ) < 0 )
	    perror( "TIOCGWINSZ ioctl" );
	if ( ws.ws_col > 20 )	/* ignore suspicious values */
	    cols = ws.ws_col;
#endif /*TIOCGWINSZ*/
	}
    
    /* Open utmp and read the users. */
    fp = fopen( _PATH_UTMP, "r" );
    if ( fp == (FILE*) 0 )
	{
	perror( "utmp" );
	exit( 1 );
	}
    users = (char**) 0;
    nusers = maxusers = 0;
    while ( fread( (char*) &ut, sizeof(ut), 1, fp ) == 1 )
	if ( ut.ut_name[0] != '\0' )
	    add_user( ut.ut_name, &users, &nusers, &maxusers );
    (void) fclose( fp );

    /* Sort both lists. */
    qsort( (char*) users, nusers, sizeof(users[0]), compare );
    qsort( (char*) hl, nhl, sizeof(hl[0]), compare );
    
    if ( uniq )
	{
	/* Get rid of dupes. */
	for ( i = 1; i < nusers; )
	    {
	    if ( strcmp( users[i-1], users[i] ) == 0 )
		{
		for ( j = i + 1; j < nusers; ++j )
		    users[j-1] = users[j];
		--nusers;
		}
	    else
		++i;
	    }
	}

    /* Show the users. */
    wid = 0;
    for ( i = 0; i < nusers; ++i )
	{
	if ( wid + strlen( users[i] ) + 3 >= cols )
	    {
	    putchar( '\n' );
	    wid = 0;
	    }
	if ( wid > 0 )
	    {
	    putchar( ' ' );
	    ++wid;
	    }
	if ( in_list( users[i], hl, nhl ) )
	    {
	    if ( ! dumb )
		tputs( high_start, 1, putch );
	    else
		putchar( '<' );
	    fputs( users[i], stdout );
	    if ( ! dumb )
		tputs( high_end, 1, putch );
	    else
		putchar( '>' );
	    if ( dumb )
		wid += 2;
	    }
	else
	    fputs( users[i], stdout );
	wid += strlen( users[i] );
	}
    putchar( '\n' );

    exit( 0 );
    }
