%%

"http://"[^>)}\], \t\r\n]+			makelink( yytext );
"www."[a-zA-Z0-9.\-]+"."(com|org|net|gov)("/"[^>)}\], \t\r\n]*|"")	makelink2( "http://", yytext );
"ftp://"[^>)}\], \t\r\n]+				makelink( yytext );
"gopher://"[^>)}\], \t\r\n]+			makelink( yytext );
"mailto:"[a-zA-Z0-9+._\-]+"@"[a-zA-Z0-9+.\-]+	makelink( yytext );
[a-zA-Z0-9+._\-]+"@"[a-zA-Z0-9+.\-]+		makelink2( "mailto:", yytext );
"telnet:"[a-zA-Z0-9+.:@\-]+			makelink( yytext );
"<"						printf( "&lt;" );
">"						printf( "&gt;" );
"&"						printf( "&amp;" );
\n\n\n*						ECHO; printf( "<P>" );
\r\r\r*						ECHO; printf( "<P>" );
\r\n\r\n[\r\n]*					ECHO; printf( "<P>" );
.|\n						ECHO;

%%
makelink( char* str )
    {
    (void) printf( "<A HREF=\"%s\">%s</A>", str, str );
    }

makelink2( char* str1, char* str2 )
    {
    (void) printf( "<A HREF=\"%s%s\">%s</A>", str1, str2, str2 );
    }
