#!/bin/sh

. /usr/local/etc/rc.subr

name=sfcmilter
rcvar=`set_rcvar`

command=/usr/local/sbin/sfcmilter

start_precmd=start_precmd

start_precmd()
{
	if [ -S "$sfcmilter_socket" ]; then
		warn "Stale socket $sfcmilter_socket removed."
		rm "$sfcmilter_socket"
	fi
}

# Set defaults.
sfcmilter_enable=${sfcmilter_enable:-"NO"}
sfcmilter_socket=${sfcmilter_socket:-"/var/run/sfcmilter.sock"}
sfcmilter_flags=${sfcmilter_flags:-"-autoupdate"}

load_rc_config $name

# Add socket to any given argument.
sfcmilter_flags="${sfcmilter_flags} ${sfcmilter_socket}"
run_rc_command "$1"
