/* wha - re-display messages from say(1)
**
** Copyright (C) 1990,1991 by Jef Poskanzer <jef@acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <errno.h>
#include "libsaywha.h"


/* Externals. */

extern int fprintf();
extern int printf();
extern char* ctime();
extern char* getenv();


/* Forward routines. */

static void cleanup();


/* Routines. */

int
main( argc, argv )
    int argc;
    char* argv[];
    {
    int argn, n, t, messages, message, writing, written;
    char* user;
    char* home;
    char filename[200];
    char buf[2000];
    char tuser[200];
    FILE* fp;
    char* usage = "usage:  %s [ <n> | <user> | <n> <user> | <user> <n> ]\n";

    /* Initialize. */
    sw_argv0 = argv[0];
    (void) signal( SIGINT, cleanup );
    (void) signal( SIGHUP, cleanup );
    if ( sw_check_sayrc() < 0 )
	(void) cleanup( 1 );
    if ( sw_check_my_sayfile() < 0 )
	(void) cleanup( 1 );

    /* Check args. */
    n = -1;
    user = (char*) 0;
    for ( argn = 1; argn < argc; ++argn )
	{
	if ( sscanf( argv[argn], "%d", &t ) == 1 )
	    {
	    if ( n != -1 )
		{
		(void) fprintf( stderr, usage, sw_argv0 );
		(void) cleanup( 1 );
		}
	    n = t;
	    }
	else
	    {
	    if ( user != (char*) 0 )
		{
		(void) fprintf( stderr, usage, sw_argv0 );
		(void) cleanup( 1 );
		}
	    user = argv[argn];
	    }
	}
    if ( n == -1 )
	n = 1;

    /* Open up the sayfile. */
    if ( ( home = getenv( "HOME" ) ) == (char*) 0 )
	{
	(void) fprintf( stderr, "%s: can't find home directory\n", sw_argv0 );
	(void) cleanup( 1 );
	}
    (void) sprintf( filename, "%s/.sayfile", home );
    if ( ( fp = fopen( filename, "r" ) ) == (FILE*) 0 )
	{
	(void) fprintf(
	    stderr, "%s: can't open .sayfile - %s\n", sw_argv0,
	    strerror( errno ) );
	(void) cleanup( 1 );
	}
    else
	{
	/* Read through once just to count up the messages that match. */
	messages = 0;
	while ( errno = 0, fgets( buf, sizeof(buf), fp ) != (char*) 0 )
	    {
	    if ( buf[0] == MSGSEP )
		{
		if ( sscanf( buf + 1, "%d,%s\n", &t, tuser ) != 2 )
		    {
		    (void) fprintf( stderr, "%s: garbled .sayfile!\n",
			sw_argv0 );
		    (void) cleanup( 1 );
		    }
		if ( user == (char*) 0 )
		    ++messages;
		else if ( strcmp( user, tuser ) == 0 )
		    ++messages;
		}
	    }
	if ( errno != 0 )
	    {
	    (void) fprintf(
		stderr, "%s: error reading .sayfile - %s\n", sw_argv0,
		strerror( errno ) );
	    (void) cleanup( 1 );
	    }
	if ( messages > 0 )
	    {
	    /* Now read through again to print. */
	    (void) rewind( fp );
	    message = 0;
	    writing = 0;
	    written = 0;
	    while ( errno = 0, fgets( buf, sizeof(buf), fp ) != (char*) 0 )
		{
		if ( buf[0] == MSGSEP )
		    {
		    if ( sscanf( buf + 1, "%d,%s\n", &t, tuser ) != 2 )
			{
			(void) fprintf( stderr, "%s: garbled .sayfile!\n",
			    sw_argv0 );
			(void) cleanup( 1 );
			}
		    if ( user == (char*) 0 || strcmp( user, tuser ) == 0 )
			{
			++message;
			if ( message > messages - n )
			    {
			    long lt;
			    char* cp;

			    writing = 1;
			    ++written;
			    if ( written > 1 )
				(void) putchar( '\n' );
#ifdef WHA_ADD_DATE
			    lt = t;
			    cp = ctime( &lt );
			    cp[strlen(cp) - 1] = '\0';
			    (void) printf( "[%s]\n", cp );
#endif /*WHA_ADD_DATE*/
			    }
			else
			    writing = 0;
			}
		    else
			writing = 0;
		    }
		else if ( writing )
		    (void) fputs( buf, stdout );
		}
	    if ( errno != 0 )
		{
		(void) fprintf(
		    stderr, "%s: error reading .sayfile - %s\n", sw_argv0,
		    strerror( errno ) );
		(void) cleanup( 1 );
		}
	    }

	if ( fclose( fp ) == EOF )
	    {
	    (void) fprintf(
		stderr, "%s: error closing %s - %s\n", sw_argv0, filename,
		strerror( errno ) );
	    (void) cleanup( 1 );
	    }
	}

    /* All done. */
    (void) cleanup( 0 );
    /*NOTREACHED*/
    }

static void
cleanup( status )
    int status;
    {
    sw_cleanup();
    exit( status );
    }
