/* rep - reply to a say(1)
**
** Copyright (C) 1991 by Jef Poskanzer <jef@acme.com>.  All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>
#include "libsaywha.h"


/* Externals. */

extern int fprintf();
extern int printf();
extern char* ctime();
extern char* getenv();
extern char* getlogin();


/* Forward routines. */

static void cleanup();


/* Routines. */

int
main( argc, argv )
    int argc;
    char* argv[];
    {
    int t;
    char* home;
    char filename[200];
    char buf[2000];
    char user[200];
    char tuser[200];
    struct passwd* pw;
    char* login;
    FILE* fp;
    char command[200];
    char* usage = "usage:  %s\n";

    /* Initialize. */
    sw_argv0 = argv[0];
    (void) signal( SIGINT, cleanup );
    (void) signal( SIGHUP, cleanup );
    if ( sw_check_sayrc() < 0 )
	(void) cleanup( 1 );
    if ( sw_check_my_sayfile() < 0 )
	(void) cleanup( 1 );

    /* Check args. */
    if ( argc != 1 )
	{
	(void) fprintf( stderr, usage, sw_argv0 );
	(void) cleanup( 1 );
	}

    /* Find out who I am. */
    if ( ( login = getlogin() ) == NULL )
	if ( pw = getpwuid( getuid() ) )
	    login = pw->pw_name;
	else
	    login = "???";

    /* Open up the sayfile. */
    if ( ( home = getenv( "HOME" ) ) == (char*) 0 )
	{
	(void) fprintf( stderr, "%s: can't find home directory\n", sw_argv0 );
	(void) cleanup( 1 );
	}
    (void) sprintf( filename, "%s/.sayfile", home );
    if ( ( fp = fopen( filename, "r" ) ) == (FILE*) 0 )
	{
	(void) fprintf(
	    stderr, "%s: can't open .sayfile - %s\n", sw_argv0,
	    strerror( errno ) );
	(void) cleanup( 1 );
	}

    /* Read through the whole sayfile, keeping track of the last
    ** user != this user.  Starting near the end would be faster, but
    ** more complicated - what do you do if there's a huge say in the
    ** file, and you don't find its beginning?
    */
    user[0] = '\0';
    while ( errno = 0, fgets( buf, sizeof(buf), fp ) != (char*) 0 )
	{
	if ( buf[0] == MSGSEP )
	    {
	    if ( sscanf( buf + 1, "%d,%s\n", &t, tuser ) != 2 )
		{
		(void) fprintf( stderr, "%s: garbled .sayfile!\n", sw_argv0 );
		(void) cleanup( 1 );
		}
	    if ( strcmp( tuser, login ) != 0 )
		(void) strcpy( user, tuser );
	    }
	}
    if ( errno != 0 )
	{
	(void) fprintf(
	    stderr, "%s: error reading .sayfile - %s\n", sw_argv0,
	    strerror( errno ) );
	(void) cleanup( 1 );
	}

    if ( fclose( fp ) == EOF )
	{
	(void) fprintf(
	    stderr, "%s: error closing %s - %s\n", sw_argv0, filename,
	    strerror( errno ) );
	(void) cleanup( 1 );
	}

    if ( user[0] == '\0' )
	{
	(void) fprintf( stderr, "%s: no one to reply to!\n", sw_argv0 );
	(void) cleanup( 1 );
	}
    
    /* Spawn a say. */
    (void) sprintf( command, "say %s", user );
    (void) printf( "%s\n", command );
    (void) system( command );

    /* All done. */
    (void) cleanup( 0 );
    /*NOTREACHED*/
    }

static void
cleanup( status )
    int status;
    {
    sw_cleanup();
    exit( status );
    }
