/* revl - reverse lines in a file, as opposed to rev which actually only
**        reverses characters in each line
**
** Copyright (C) 1991,1994 by Jef Poskanzer <jef@acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


static void readlines( FILE* f );
static void* malloc_check( size_t size );
static void* realloc_check( void* ptr, size_t size );
static char* strdup_check( char* str ); 
static void check( void* ptr );


static char* argv0;
static int nlines, maxlines;
static char** lines;


int
main( int argc, char** argv )
    {
    FILE* f;
    int i;

    argv0 = argv[0];
    maxlines = 100;
    lines = (char**) malloc_check( maxlines * sizeof(char*) );
    nlines = 0;

    if ( argc == 1 )
	readlines( stdin );
    else
	for ( i = 1; i < argc; ++i )
	    {
	    if ( strcmp( argv[i], "-" ) == 0 )
		readlines( stdin );
	    else
		{
		f = fopen( argv[i], "r" );
		if ( f == (FILE*) 0 )
		    {
		    perror( argv[i] );
		    exit( 1 );
		    }
		readlines( f );
		fclose( f );
		}
	    }

    for ( i = nlines - 1; i >= 0; --i )
	fputs( lines[i], stdout );

    exit( 0 );
    }


static void
readlines( FILE* f )
    {
    char line[30000];

    while ( fgets( line, sizeof(line), f ) != NULL )
	{
	if ( nlines >= maxlines )
	    {
	    maxlines *= 2;
	    lines = (char**) realloc_check(
		(void*) lines, maxlines * sizeof(char*) );
	    }
	lines[nlines] = strdup_check( line );
	++nlines;
	}
    }


static void*
malloc_check( size_t size )
    {
    void* ptr = malloc( size );
    check( ptr );
    return ptr;
    }


static void*
realloc_check( void* ptr, size_t size )
    {
    ptr = realloc( ptr, size );
    check( ptr );
    return ptr;
    }


static char*
strdup_check( char* str )
    {
    str = strdup( str );
    check( (void*) str );
    return str;
    }


static void
check( void* ptr )
    {
    if ( ptr == (void*) 0 )
	{
	(void) fprintf( stderr, "%s: out of memory\n", argv0 );
	exit( 1 );
	}
    }
