/* ipizer - improve a sendmail log file by adding IP addresses
**
** Copyright  2005 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
**
** For commentary on this license please see http://www.acme.com/license.html
*/

%x PID
%x MESSAGE
%x CONNECT
%x IP
%x JUNK
%x NONCONNECT

%{
#include <stdlib.h>

#define N_PIDS 100000
#define MAX_IPLEN 16

int pid;
char ips[100000][MAX_IPLEN];

%}

%%

\[					{ ECHO; BEGIN(PID); }
[^\[]+					ECHO;

<PID>[0-9]+\]				{ ECHO; pid = atoi( yytext ); BEGIN(MESSAGE); }
<PID>.					{ ECHO; BEGIN(JUNK); }

<MESSAGE>:\ NOQUEUE:\ connect\ from\ 	{ ECHO; BEGIN(CONNECT); }
<MESSAGE>.				{ ECHO; BEGIN(NONCONNECT); }

<CONNECT>[^\[\n]+			ECHO;
<CONNECT>\[				{ ECHO; BEGIN(IP); }
<CONNECT>\n				{ ECHO; BEGIN(0); }

<IP>[0-9.]+				{
					ECHO;
					if ( pid >= 0 && pid < N_PIDS && strlen( yytext ) < MAX_IPLEN )
					    (void) strcpy( ips[pid], yytext );
					BEGIN(JUNK);
					}
<IP>[^\n]				{ ECHO; BEGIN(JUNK); }
<IP>\n					{ ECHO; BEGIN(0); }

<JUNK>.+				ECHO;
<JUNK>\n				{ ECHO; BEGIN(0); }

<NONCONNECT>.+				ECHO;
<NONCONNECT>\n				{
					if ( pid >= 0 && pid < N_PIDS && ips[pid][0] != '\0' )
					    (void) printf( " [%s]", ips[pid] );
					ECHO;
					BEGIN(0);
					}

%%

int
main( int argc, char** argv )
    {
    for ( pid = 0; pid < N_PIDS; ++pid )
	ips[pid][0] = '\0';
    yylex();
    exit( 0 );
    }
