#!/bin/sh

. /usr/local/etc/rc.subr

name=graymilter
rcvar=`set_rcvar`

command=/usr/local/sbin/graymilter

start_precmd=start_precmd

start_precmd()
{
	if [ -S "$graymilter_socket" ]; then
		warn "Stale socket $graymilter_socket removed."
		rm "$graymilter_socket"
	fi
}

# Set defaults.
graymilter_enable=${graymilter_enable:-"NO"}
graymilter_socket=${graymilter_socket:-"/var/run/graymilter.sock"}
graymilter_flags=${graymilter_flags:-"-autoupdate"}

load_rc_config $name

# Add socket to any given argument.
graymilter_flags="${graymilter_flags} ${graymilter_socket}"
run_rc_command "$1"
