/* find_old_files - find files older than a specified time-offset
**
** Copyright  1998 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <sys/stat.h>


static char* argv0;

static void usage( void );
static int traverse( char* dirname, time_t t );


int
main( int argc, char** argv )
    {
    char* dirname;
    char* offset;
    int offset_val;
    char offset_type;
    int offset_mult;
    time_t t;

    argv0 = argv[0];
    if ( argc != 3 )
	usage();
    dirname = argv[1];
    offset = argv[2];
    offset_val = atoi( offset );
    offset_type = offset[ strlen( offset ) - 1 ];
    switch ( offset_type )
	{
	case 'h': case 'H': offset_mult = 3600; break;
	case 'm': case 'M': offset_mult = 60; break;
	case 's': case 'S': offset_mult = 1; break;
	default: usage();
	}

    t = time( (time_t*) 0 );
    t -= offset_val * offset_mult;

    if ( traverse( dirname, t ) == -1 )
	{
	perror( dirname );
	exit( -1 );
	}

    exit( 0 );
    }


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s dir offset[hms]\n", argv0 );
    exit( 1 );
    }


static int
traverse( char* dirname, time_t t )
    {
    DIR* dirp;
    struct dirent* de;
    char path[2000];
    struct stat sb;

    dirp = opendir( dirname );
    if ( dirp == (DIR*) 0 )
	return -1;
    while ( ( de = readdir( dirp ) ) != 0 )
	{
	/* Skip "." and "..". */
	if ( strcmp( de->d_name, "." ) == 0 || strcmp( de->d_name, ".." ) == 0 )
	    continue;
	(void) sprintf( path, "%.999s/%.999s", dirname, de->d_name );
	if ( lstat( path, &sb ) < 0 )
	    {
	    char buf[1100];
	    (void) sprintf( buf, "%s: couldn't stat %.1000s - ", argv0, path );
	    perror( buf );
	    continue;
	    }
	switch ( sb.st_mode & S_IFMT )
	    {
	    case S_IFREG:
	    if ( sb.st_mtime < t )
		printf( "%s\n", path );
	    break;
	    case S_IFDIR:
	    traverse( path, t );
	    break;
	    }
	}
    closedir( dirp );
    return 0;
    }
