/* file_date - display the date of a given file
**
** Copyright  2005 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>


static char* argv0;

static void usage( void );
static void file_date( const char* filename, int ctime, int atime, int gmt, const char* format );
static void trim( char* str );


int
main( int argc, char** argv )
    {
    int argn;
    int ctime, atime, gmt;
    const char* format;
    char buf[10000];

    argv0 = argv[0];
    argn = 1;
    ctime = 0;
    atime = 0;
    gmt = 0;
    /* Default format is Wdy Mon  d hh:mm:ss Zon Year. */
    format = "%a %b %e %H:%M:%S %Z %Y";
    while ( argn < argc && argv[argn][0] == '-' && argv[argn][1] >= 'a' && argv[argn][1] <= 'z' )
	{
	if ( strncmp( argv[argn], "-c", 2 ) == 0 )
	    ctime = 1;
	else if ( strncmp( argv[argn], "-a", 2 ) == 0 )
	    atime = 1;
	else if ( strncmp( argv[argn], "-u", 2 ) == 0 )
	    gmt = 1;
	else if ( strncmp( argv[argn], "-f", 2 ) == 0 )
	    {
	    ++argn;
	    if ( argn >= argc )
		usage();
	    format = argv[argn];
	    }
	else
	    usage();
	++argn;
	}
    if ( ctime && atime )
	usage();

    if ( argn == argc )
	{
	while ( fgets( buf, sizeof(buf), stdin ) != (char*) 0 )
	    {
	    trim( buf );
	    (void) printf( "%s: ", buf );
	    file_date( buf, ctime, atime, gmt, format );
	    }
	}
    else if ( argn == argc - 1 )
	file_date( argv[argn], ctime, atime, gmt, format );
    else
	{
	while ( argn < argc )
	    {
	    (void) printf( "%s: ", argv[argn] );
	    file_date( argv[argn], ctime, atime, gmt, format );
	    ++argn;
	    }
	}

    exit( 0 );
    }


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s [-c] [-a] [-u] [-f format] [filename ...]\n", argv0 );
    exit( 1 );
    }


static void
file_date( const char* filename, int ctime, int atime, int gmt, const char* format )
    {
    struct stat sb;
    time_t t;
    struct tm* tmP;
    char buf[1000];

    if ( stat( filename, &sb ) != 0 )
	perror( filename );
    if ( ctime )
	t = sb.st_ctime;
    else if ( atime )
	t = sb.st_atime;
    else
	t = sb.st_mtime;
    if ( gmt )
	tmP = gmtime( &t );
    else
	tmP = localtime( &t );
    (void) strftime( buf, sizeof(buf), format, tmP );
    (void) printf( "%s\n", buf );
    }


static void
trim( char* str )
    {
    size_t len;

    len = strlen( str );
    while ( str[len-1] == '\n' )
	str[--len] = '\0';
    }
