/* libdb.h - library for simple database manager
**
** Copyright  2009 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
**
** For commentary on this license please see http://www.acme.com/license.html
*/

#ifndef _LIBDB_H_
#define _LIBDB_H_

extern void* db_openread( char* filename );
/* Returns (void*) 0 on error. */

extern void* db_openwrite( char* filename );
/* Returns (void*) 0 on error. */

extern int db_get( void* db, char* key, char* value, size_t value_size );
/* Returns -1 on error, 1 on key not found, 0 on success.  */

extern int db_next( void* db, char* key, size_t key_size, char* value, size_t value_size );
/* Returns -1 on error, 1 on eof, 0 on success. */

extern int db_put( void* db, char* key, char* value );
/* Returns -1 on error, 0 on success. */

extern int db_del( void* db, char* key );
/* Returns -1 on error, 1 on key not found, 0 on success. */

extern int db_close( void* db );
/* Returns -1 on error, 0 on success. */

#endif /*_LIBDB_H_*/
