/* xmit_time - figure out transmission time of netnews articles
**
** Copyright (C) 1995 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>

#include "date_parse.h"

static void usage();
static void do_file();

static char* argv0;


static void
do_file( char* name )
    {
    struct stat sb;
    time_t posted, arrived;
    FILE* f;
    char line[30000];

    f = fopen( name, "r" );
    if ( f == (FILE*) 0 )
	{
	perror( name );
	return;
	}

    if ( fstat( fileno( f ), &sb ) < 0 )
	{
	perror( name );
	(void) fclose( f );
	return;
	}
    arrived = sb.st_mtime;

    for (;;)
	{
	if ( fgets( line, sizeof(line), f ) == (char*) 0 )
	    break;
	if ( line[0] == '\n' )
	    break;
	if ( strncmp( line, "Date:", 5 ) == 0 )
	    {
	    (void) fclose( f );
	    posted = date_parse( &line[5] );
	    if ( posted == (time_t) -1 )
		(void) fprintf(
		    stderr, "%s: unparsable date in %s - %s",
		    argv0, name, &line[5] );
	    else
		(void) printf( "%d\n", arrived - posted );
	    return;
	    }
	}

    (void) fprintf( stderr, "%s: no Date: line found in %s\n", argv0, name );
    (void) fclose( f );
    }


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s file ...\n", argv0 );
    exit( 1 );
    }


int
main( int argc, char** argv )
    {
    int argn;

    argv0 = argv[0];
    argn = 1;
    if ( argn < argc && argv[argn][0] == '-' && argv[argn][1] != '\0' )
	usage();

    while ( argn < argc )
	{
	do_file( argv[argn] );
	++argn;
	}

    exit( 0 );
    }
