/* date_order - order filenames by date
**
** Copyright (C) 1995 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "date_parse.h"

static char* argv0;

struct file
    {
    char* name;
    time_t date;
    };

static int maxfiles, nfiles;
static struct file* files;


static void
out_of_mem( void )
    {
    (void) fprintf( stderr, "%s: out of memory\n", argv0 );
    exit( 1 );
    }


static void*
my_realloc( void* p, size_t size )
    {
    void* r;

    r = realloc( p, size );
    if ( r == (void*) 0 )
	out_of_mem();
    return r;
    }


static void*
my_malloc( size_t size )
    {
    void* r;

    r = malloc( size );
    if ( r == (void*) 0 )
	out_of_mem();
    return r;
    }


static int
file_compare( f1, f2 )
    struct file* f1;
    struct file* f2;
    {
    return f1->date - f2->date;
    }


static time_t
date_file( char* name )
    {
    FILE* f;
    char line[30000];
    time_t t;

    f = fopen( name, "r" );
    if ( f == (FILE*) 0 )
	{
	perror( name );
	return (time_t) -1;
	}

    for (;;)
	{
	if ( fgets( line, sizeof(line), f ) == (char*) 0 )
	    break;
	if ( line[0] == '\n' )
	    break;
	if ( strncmp( line, "Date:", 5 ) == 0 )
	    {
	    (void) fclose( f );
	    t = date_parse( &line[5] );
	    if ( t == (time_t) -1 )
		(void) fprintf(
		    stderr, "%s: unparsable date in %s - %s",
		    argv0, name, &line[5] );
	    return t;
	    }
	}

    (void) fprintf( stderr, "%s: no Date: line found in %s\n", argv0, name );
    (void) fclose( f );
    return (time_t) -1;
    }


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s [file ...]\n", argv0 );
    exit( 1 );
    }


int
main( int argc, char** argv )
    {
    int argn;
    int i;

    argv0 = argv[0];
    argn = 1;
    if ( argn < argc && argv[argn][0] == '-' && argv[argn][1] != '\0' )
	usage();

    maxfiles = argc - argn;
    files = (struct file*) my_malloc( maxfiles * sizeof(struct file) );
    nfiles = 0;

    while ( argn < argc )
	{
	files[nfiles].name = (char*) my_malloc( strlen( argv[argn] ) + 1 );
	(void) strcpy( files[nfiles].name, argv[argn] );
	files[nfiles].date = date_file( argv[argn] );
	++nfiles;
	++argn;
	}

    qsort( files, nfiles, sizeof(struct file), file_compare );

    for ( i = 0; i < nfiles; ++i )
	{
	if ( i != 0 )
	    putchar( ' ' );
	fputs( files[i].name, stdout );
	}
    putchar( '\n' );

    exit( 0 );
    }
