/* deltime - show difference between two dates
**
** Copyright (C) 1995 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include "date_parse.h"

static char* argv0;

#define SECSPERMINUTE 60
#define SECSPERHOUR (60 * SECSPERMINUTE)
#define SECSPERDAY (24 * SECSPERHOUR)

static void usage( void ) __attribute__ ((noreturn));
static void unparsable( char* str ) __attribute__ ((noreturn));


int
main( int argc, char** argv )
    {
    int hour_format;
    int seconds_format;
    time_t t1, t2;
    long delta;
    long days, hours, minutes, secs;

    argv0 = argv[0];

    hour_format = 0;
    seconds_format = 0;
    if ( argc >= 2 )
	{
	if ( strcmp( argv[1], "-h" ) == 0 )
	    {
	    hour_format = 1;
	    ++argv;
	    --argc;
	    }
	else if ( strcmp( argv[1], "-s" ) == 0 )
	    {
	    seconds_format = 1;
	    ++argv;
	    --argc;
	    }
	}

    if ( argc == 2 )
	{
	t1 = date_parse( argv[1] );
	if ( t1 == (time_t) -1 )
	    unparsable( argv[1] );
	t2 = time( (time_t*) 0 );
	}
    else if ( argc == 3 )
	{
	t1 = date_parse( argv[1] );
	if ( t1 == (time_t) -1 )
	    unparsable( argv[1] );
	t2 = date_parse( argv[2] );
	if ( t2 == (time_t) -1 )
	    unparsable( argv[2] );
	}
    else
	usage();

    delta = t2 - t1;
    if ( delta < 0 )
	{
	(void) printf( "-" );
	delta = -delta;
	}

    secs = delta;
    days = secs / SECSPERDAY;
    secs -= days * SECSPERDAY;
    hours = secs / SECSPERHOUR;
    secs -= hours * SECSPERHOUR;
    minutes = secs / SECSPERMINUTE;
    secs -= minutes * SECSPERMINUTE;

    if ( hour_format )
	(void) printf( "%ld:%02ld:%02ld\n", days * 24 + hours, minutes, secs );
    else if ( seconds_format )
	(void) printf( "%ld\n", delta );
    else
	(void) printf( "%ld %2ld:%02ld:%02ld\n", days, hours, minutes, secs );

    exit( 0 );
    }


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s [-h|-s] date1 [date2]\n", argv0 );
    exit( 1 );
    }


static void
unparsable( char* str )
    {
    (void) fprintf( stderr, "%s: unparsable date - %s\n", argv0, str );
    exit( 1 );
    }
