/* date_offset - display the date and time, with an offset
**
** Copyright  1998 by Jef Poskanzer <jef@mail.acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>


static char* argv0;


static void
usage( void )
    {
    (void) fprintf( stderr, "usage:  %s [-u] [-f format] offset\n", argv0 );
    exit( 1 );
    }


int
main( int argc, char** argv )
    {
    int argn;
    int gmt;
    char* format;
    char* offset;
    int offset_sign = 1;
    int offset_val;
    char offset_type;
    int offset_mult = 1;
    time_t t;
    struct tm* tmP;
    char buf[1000];

    argv0 = argv[0];
    argn = 1;
    gmt = 0;
    /* Default format is Wdy Mon  d hh:mm:ss Zon Year. */
    format = "%a %b %e %H:%M:%S %Z %Y";
    while ( argn < argc && argv[argn][0] == '-' && argv[argn][1] >= 'a' && argv[argn][1] <= 'z' )
	{
	if ( strncmp( argv[argn], "-u", 2 ) == 0 )
	    gmt = 1;
	else if ( strncmp( argv[argn], "-f", 2 ) == 0 )
	    {
	    ++argn;
	    if ( argn >= argc )
		usage();
	    format = argv[argn];
	    }
	else
	    usage();
	++argn;
	}
    if ( argn != argc - 1 )
	usage();

    offset = argv[argn];
    switch ( offset[0] )
	{
	case '+': offset_sign = 1; break;
	case '-': offset_sign = -1; break;
	default: usage();
	}
    offset_type = offset[ strlen( offset ) - 1 ];
    switch ( offset_type )
	{
	case 's': case 'S': offset_mult = 1; break;
	case 'm': case 'M': offset_mult = 60; break;
	case 'h': case 'H': offset_mult = 3600; break;
	case 'd': case 'D': offset_mult = 86400; break;
	default: usage();
	}
    offset_val = atoi( &offset[1] );

    t = time( (time_t*) 0 );
    t += offset_val * offset_mult * offset_sign;
    if ( gmt )
	tmP = gmtime( &t );
    else
	tmP = localtime( &t );
    (void) strftime( buf, sizeof(buf), format, tmP );
    (void) printf( "%s\n", buf );
    exit( 0 );
    }
