#!/bin/sh

. /usr/local/etc/rc.subr

name=blackmilter
rcvar=`set_rcvar`

command=/usr/local/sbin/blackmilter

start_precmd=start_precmd

start_precmd()
{
	if [ -S "$blackmilter_socket" ]; then
		warn "Stale socket $blackmilter_socket removed."
		rm "$blackmilter_socket"
	fi
}

# Set defaults.
blackmilter_enable=${blackmilter_enable:-"NO"}
blackmilter_socket=${blackmilter_socket:-"/var/run/blackmilter.sock"}
blackmilter_flags=${blackmilter_flags:-"-autoupdate"}

load_rc_config $name

# Add socket to any given argument.
blackmilter_flags="${blackmilter_flags} ${blackmilter_socket}"
run_rc_command "$1"
