// xmltest - test the XML parser
//
// This just calls XmlParser on a specified inout file, displaying
// the parsed results.


// Copyright  2003 by Jef Poskanzer <jef@mail.acme.com>.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//
// For commentary on this license please see http://www.acme.com/license.html


#include <fstream>

#include "XmlParser.h"


int main( int argc, char* argv[] )
    {
    if ( argc != 2 )
	{
	std::cerr << "usage: " << argv[0] << " filename\n";
	exit( 1 );
	}
    try {
	std::ifstream is( argv[1] );
	XIP* xp = new XmlParser( &is );
	while ( xp->hasMoreText() )
	    {
	    const XipText& xt = xp->getNextText();
	    std::string desc;
	    if ( xt.isCdata )
		desc = "CDATA";
	    else
		desc = "text";
	    std::cout << "Got " << desc << " at line " << xt.startline << ", length " << xt.text.length() << ": '" << xt.text << "' with elements:\n";
	    for ( XipElementVec::const_iterator i = xt.elements.begin(); i != xt.elements.end(); ++i )
		{
		std::cout << "    " << i->id << ": " << i->name << "\n";
		for ( XipAttributes::const_iterator j = i->attributes.begin(); j != i->attributes.end(); ++j )
		    std::cout << "        " << j->first << "=" << j->second << "\n";
		}
	    }
	delete xp;
	is.close();
	}
    catch ( XipException e )
	{
	std::cerr << e.reason << " at line " << e.line << "\n";
	exit( 1 );
	}

    exit( 0 );
    }
